@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-sm-12 col-md-8">
                    <div class="box_header">
                        <div class="main-title d-flex justify-content-between w-100">
                            <h3 class="mb-0 mr-30">{{ __('setting.Upload Theme') }}</h3>

                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-8">
                    <div class="white-box text-center">
                        <div style="padding:50px; " class="card mt-25">
                            <form action="{{ route('appearance.themes.store') }}" method="POST"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('POST')
                                <div class="row mt-50">
                                    <div class="col-xl-6">
                                        <div class="primary_input mb-35">
                                            <div class="primary_file_uploader">

                                                <label for="placeholderFileOneName" class="d-none"></label>
                                                <input class="primary-input" type="text" id="placeholderFileOneName"
                                                       placeholder="{{ __('setting.Browse Zip') }}" readonly="">
                                                <button class="" type="button">
                                                    <label class="primary-btn small fix-gr-bg"
                                                           for="document_file_1">{{ __('common.Browse') }}</label>
                                                    <input type="file" class="d-none" name="themeZip"
                                                           id="document_file_1"
                                                           onchange="nameChange(this.value)">
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div style="padding-top: 6px;" class="col-xl-6">
                                        <button id="submitBtn" type="submit" disabled
                                                class="btn primary-btn small fix-gr-bg">{{ __('setting.Install Now') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script>
        function getFileName(value, placeholder) {
            if (value) {
                const startIndex = (value.indexOf('\\') >= 0 ? value.lastIndexOf('\\') : value.lastIndexOf('/'));
                let filename = value.substring(startIndex);
                if (filename.indexOf('\\') === 0 || filename.indexOf('/') === 0) {
                    filename = filename.substring(1);
                }
                $(placeholder).attr('placeholder', '');
                $(placeholder).attr('placeholder', filename);
            }
        }

        function nameChange(value) {

            getFileName(value, '#placeholderFileOneName');
            $('#submitBtn').attr('disabled', false);
        }

        function DeleteTheme(id) {
            $('#delete_item_id').val(id);
            $('#deleteItemModal').modal('show');
        }

    </script>
@endpush
