<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/common/v1/message.proto

namespace Temporal\Api\Common\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * Priority contains metadata that controls relative ordering of task processing
 * when tasks are backed up in a queue. Initially, Priority will be used in
 * matching (workflow and activity) task queues. Later it may be used in history
 * task queues and in rate limiting decisions.
 * Priority is attached to workflows and activities. By default, activities
 * inherit Priority from the workflow that created them, but may override fields
 * when an activity is started or modified.
 * Despite being named "Priority", this message also contains fields that
 * control "fairness" mechanisms.
 * For all fields, the field not present or equal to zero/empty string means to
 * inherit the value from the calling workflow, or if there is no calling
 * workflow, then use the default value.
 * For all fields other than fairness_key, the zero value isn't meaningful so
 * there's no confusion between inherit/default and a meaningful value. For
 * fairness_key, the empty string will be interpreted as "inherit". This means
 * that if a workflow has a non-empty fairness key, you can't override the
 * fairness key of its activity to the empty string.
 * The overall semantics of Priority are:
 * 1. First, consider "priority": higher priority (lower number) goes first.
 * 2. Then, consider fairness: try to dispatch tasks for different fairness keys
 *    in proportion to their weight.
 * Applications may use any subset of mechanisms that are useful to them and
 * leave the other fields to use default values.
 * Not all queues in the system may support the "full" semantics of all priority
 * fields. (Currently only support in matching task queues is planned.)
 *
 * Generated from protobuf message <code>temporal.api.common.v1.Priority</code>
 */
class Priority extends \Google\Protobuf\Internal\Message
{
    /**
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     *
     * Generated from protobuf field <code>int32 priority_key = 1;</code>
     */
    protected $priority_key = 0;
    /**
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     * Fairness keys are limited to 64 bytes.
     *
     * Generated from protobuf field <code>string fairness_key = 2;</code>
     */
    protected $fairness_key = '';
    /**
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     * Weight values are clamped to the range [0.001, 1000].
     *
     * Generated from protobuf field <code>float fairness_weight = 3;</code>
     */
    protected $fairness_weight = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $priority_key
     *           Priority key is a positive integer from 1 to n, where smaller integers
     *           correspond to higher priorities (tasks run sooner). In general, tasks in
     *           a queue should be processed in close to priority order, although small
     *           deviations are possible.
     *           The maximum priority value (minimum priority) is determined by server
     *           configuration, and defaults to 5.
     *           If priority is not present (or zero), then the effective priority will be
     *           the default priority, which is is calculated by (min+max)/2. With the
     *           default max of 5, and min of 1, that comes out to 3.
     *     @type string $fairness_key
     *           Fairness key is a short string that's used as a key for a fairness
     *           balancing mechanism. It may correspond to a tenant id, or to a fixed
     *           string like "high" or "low". The default is the empty string.
     *           The fairness mechanism attempts to dispatch tasks for a given key in
     *           proportion to its weight. For example, using a thousand distinct tenant
     *           ids, each with a weight of 1.0 (the default) will result in each tenant
     *           getting a roughly equal share of task dispatch throughput.
     *           (Note: this does not imply equal share of worker capacity! Fairness
     *           decisions are made based on queue statistics, not
     *           current worker load.)
     *           As another example, using keys "high" and "low" with weight 9.0 and 1.0
     *           respectively will prefer dispatching "high" tasks over "low" tasks at a
     *           9:1 ratio, while allowing either key to use all worker capacity if the
     *           other is not present.
     *           All fairness mechanisms, including rate limits, are best-effort and
     *           probabilistic. The results may not match what a "perfect" algorithm with
     *           infinite resources would produce. The more unique keys are used, the less
     *           accurate the results will be.
     *           Fairness keys are limited to 64 bytes.
     *     @type float $fairness_weight
     *           Fairness weight for a task can come from multiple sources for
     *           flexibility. From highest to lowest precedence:
     *           1. Weights for a small set of keys can be overridden in task queue
     *              configuration with an API.
     *           2. It can be attached to the workflow/activity in this field.
     *           3. The default weight of 1.0 will be used.
     *           Weight values are clamped to the range [0.001, 1000].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\Common\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     *
     * Generated from protobuf field <code>int32 priority_key = 1;</code>
     * @return int
     */
    public function getPriorityKey()
    {
        return $this->priority_key;
    }

    /**
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     *
     * Generated from protobuf field <code>int32 priority_key = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setPriorityKey($var)
    {
        GPBUtil::checkInt32($var);
        $this->priority_key = $var;

        return $this;
    }

    /**
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     * Fairness keys are limited to 64 bytes.
     *
     * Generated from protobuf field <code>string fairness_key = 2;</code>
     * @return string
     */
    public function getFairnessKey()
    {
        return $this->fairness_key;
    }

    /**
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     * Fairness keys are limited to 64 bytes.
     *
     * Generated from protobuf field <code>string fairness_key = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setFairnessKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->fairness_key = $var;

        return $this;
    }

    /**
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     * Weight values are clamped to the range [0.001, 1000].
     *
     * Generated from protobuf field <code>float fairness_weight = 3;</code>
     * @return float
     */
    public function getFairnessWeight()
    {
        return $this->fairness_weight;
    }

    /**
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     * Weight values are clamped to the range [0.001, 1000].
     *
     * Generated from protobuf field <code>float fairness_weight = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setFairnessWeight($var)
    {
        GPBUtil::checkFloat($var);
        $this->fairness_weight = $var;

        return $this;
    }

}

