<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/common/v1/message.proto

namespace Temporal\Api\Common\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * Describes where and how to reset a workflow, used for batch reset currently
 * and may be used for single-workflow reset later.
 *
 * Generated from protobuf message <code>temporal.api.common.v1.ResetOptions</code>
 */
class ResetOptions extends \Google\Protobuf\Internal\Message
{
    /**
     * Deprecated. Use `options`.
     * Default: RESET_REAPPLY_TYPE_SIGNAL
     *
     * Generated from protobuf field <code>.temporal.api.enums.v1.ResetReapplyType reset_reapply_type = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $reset_reapply_type = 0;
    /**
     * If true, limit the reset to only within the current run. (Applies to build_id targets and
     * possibly others in the future.)
     *
     * Generated from protobuf field <code>bool current_run_only = 11;</code>
     */
    protected $current_run_only = false;
    /**
     * Event types not to be reapplied
     *
     * Generated from protobuf field <code>repeated .temporal.api.enums.v1.ResetReapplyExcludeType reset_reapply_exclude_types = 12;</code>
     */
    private $reset_reapply_exclude_types;
    protected $target;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\GPBEmpty $first_workflow_task
     *           Resets to the first workflow task completed or started event.
     *     @type \Google\Protobuf\GPBEmpty $last_workflow_task
     *           Resets to the last workflow task completed or started event.
     *     @type int|string $workflow_task_id
     *           The id of a specific `WORKFLOW_TASK_COMPLETED`,`WORKFLOW_TASK_TIMED_OUT`, `WORKFLOW_TASK_FAILED`, or
     *           `WORKFLOW_TASK_STARTED` event to reset to.
     *           Note that this option doesn't make sense when used as part of a batch request.
     *     @type string $build_id
     *           Resets to the first workflow task processed by this build id.
     *           If the workflow was not processed by the build id, or the workflow task can't be
     *           determined, no reset will be performed.
     *           Note that by default, this reset is allowed to be to a prior run in a chain of
     *           continue-as-new.
     *     @type int $reset_reapply_type
     *           Deprecated. Use `options`.
     *           Default: RESET_REAPPLY_TYPE_SIGNAL
     *     @type bool $current_run_only
     *           If true, limit the reset to only within the current run. (Applies to build_id targets and
     *           possibly others in the future.)
     *     @type int[] $reset_reapply_exclude_types
     *           Event types not to be reapplied
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\Common\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Resets to the first workflow task completed or started event.
     *
     * Generated from protobuf field <code>.google.protobuf.Empty first_workflow_task = 1;</code>
     * @return \Google\Protobuf\GPBEmpty|null
     */
    public function getFirstWorkflowTask()
    {
        return $this->readOneof(1);
    }

    public function hasFirstWorkflowTask()
    {
        return $this->hasOneof(1);
    }

    /**
     * Resets to the first workflow task completed or started event.
     *
     * Generated from protobuf field <code>.google.protobuf.Empty first_workflow_task = 1;</code>
     * @param \Google\Protobuf\GPBEmpty $var
     * @return $this
     */
    public function setFirstWorkflowTask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\GPBEmpty::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Resets to the last workflow task completed or started event.
     *
     * Generated from protobuf field <code>.google.protobuf.Empty last_workflow_task = 2;</code>
     * @return \Google\Protobuf\GPBEmpty|null
     */
    public function getLastWorkflowTask()
    {
        return $this->readOneof(2);
    }

    public function hasLastWorkflowTask()
    {
        return $this->hasOneof(2);
    }

    /**
     * Resets to the last workflow task completed or started event.
     *
     * Generated from protobuf field <code>.google.protobuf.Empty last_workflow_task = 2;</code>
     * @param \Google\Protobuf\GPBEmpty $var
     * @return $this
     */
    public function setLastWorkflowTask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\GPBEmpty::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The id of a specific `WORKFLOW_TASK_COMPLETED`,`WORKFLOW_TASK_TIMED_OUT`, `WORKFLOW_TASK_FAILED`, or
     * `WORKFLOW_TASK_STARTED` event to reset to.
     * Note that this option doesn't make sense when used as part of a batch request.
     *
     * Generated from protobuf field <code>int64 workflow_task_id = 3;</code>
     * @return int|string
     */
    public function getWorkflowTaskId()
    {
        return $this->readOneof(3);
    }

    public function hasWorkflowTaskId()
    {
        return $this->hasOneof(3);
    }

    /**
     * The id of a specific `WORKFLOW_TASK_COMPLETED`,`WORKFLOW_TASK_TIMED_OUT`, `WORKFLOW_TASK_FAILED`, or
     * `WORKFLOW_TASK_STARTED` event to reset to.
     * Note that this option doesn't make sense when used as part of a batch request.
     *
     * Generated from protobuf field <code>int64 workflow_task_id = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setWorkflowTaskId($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Resets to the first workflow task processed by this build id.
     * If the workflow was not processed by the build id, or the workflow task can't be
     * determined, no reset will be performed.
     * Note that by default, this reset is allowed to be to a prior run in a chain of
     * continue-as-new.
     *
     * Generated from protobuf field <code>string build_id = 4;</code>
     * @return string
     */
    public function getBuildId()
    {
        return $this->readOneof(4);
    }

    public function hasBuildId()
    {
        return $this->hasOneof(4);
    }

    /**
     * Resets to the first workflow task processed by this build id.
     * If the workflow was not processed by the build id, or the workflow task can't be
     * determined, no reset will be performed.
     * Note that by default, this reset is allowed to be to a prior run in a chain of
     * continue-as-new.
     *
     * Generated from protobuf field <code>string build_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setBuildId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Deprecated. Use `options`.
     * Default: RESET_REAPPLY_TYPE_SIGNAL
     *
     * Generated from protobuf field <code>.temporal.api.enums.v1.ResetReapplyType reset_reapply_type = 10 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getResetReapplyType()
    {
        if ($this->reset_reapply_type !== 0) {
            @trigger_error('reset_reapply_type is deprecated.', E_USER_DEPRECATED);
        }
        return $this->reset_reapply_type;
    }

    /**
     * Deprecated. Use `options`.
     * Default: RESET_REAPPLY_TYPE_SIGNAL
     *
     * Generated from protobuf field <code>.temporal.api.enums.v1.ResetReapplyType reset_reapply_type = 10 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setResetReapplyType($var)
    {
        @trigger_error('reset_reapply_type is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Temporal\Api\Enums\V1\ResetReapplyType::class);
        $this->reset_reapply_type = $var;

        return $this;
    }

    /**
     * If true, limit the reset to only within the current run. (Applies to build_id targets and
     * possibly others in the future.)
     *
     * Generated from protobuf field <code>bool current_run_only = 11;</code>
     * @return bool
     */
    public function getCurrentRunOnly()
    {
        return $this->current_run_only;
    }

    /**
     * If true, limit the reset to only within the current run. (Applies to build_id targets and
     * possibly others in the future.)
     *
     * Generated from protobuf field <code>bool current_run_only = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setCurrentRunOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->current_run_only = $var;

        return $this;
    }

    /**
     * Event types not to be reapplied
     *
     * Generated from protobuf field <code>repeated .temporal.api.enums.v1.ResetReapplyExcludeType reset_reapply_exclude_types = 12;</code>
     * @return RepeatedField<int>
     */
    public function getResetReapplyExcludeTypes()
    {
        return $this->reset_reapply_exclude_types;
    }

    /**
     * Event types not to be reapplied
     *
     * Generated from protobuf field <code>repeated .temporal.api.enums.v1.ResetReapplyExcludeType reset_reapply_exclude_types = 12;</code>
     * @param int[] $var
     * @return $this
     */
    public function setResetReapplyExcludeTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Temporal\Api\Enums\V1\ResetReapplyExcludeType::class);
        $this->reset_reapply_exclude_types = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->whichOneof("target");
    }

}

