<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/history/v1/message.proto

namespace Temporal\Api\History\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * History events are the method by which Temporal SDKs advance (or recreate) workflow state.
 * See the `EventType` enum for more info about what each event is for.
 *
 * Generated from protobuf message <code>temporal.api.history.v1.HistoryEvent</code>
 */
class HistoryEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Monotonically increasing event number, starts at 1.
     *
     * Generated from protobuf field <code>int64 event_id = 1;</code>
     */
    protected $event_id = 0;
    /**
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 2;</code>
     */
    protected $event_time = null;
    /**
     * Generated from protobuf field <code>.temporal.api.enums.v1.EventType event_type = 3;</code>
     */
    protected $event_type = 0;
    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 version = 4;</code>
     */
    protected $version = 0;
    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 task_id = 5;</code>
     */
    protected $task_id = 0;
    /**
     * Set to true when the SDK may ignore the event as it does not impact workflow state or
     * information in any way that the SDK need be concerned with. If an SDK encounters an event
     * type which it does not understand, it must error unless this is true. If it is true, it's
     * acceptable for the event type and/or attributes to be uninterpretable.
     *
     * Generated from protobuf field <code>bool worker_may_ignore = 300;</code>
     */
    protected $worker_may_ignore = false;
    /**
     * Metadata on the event. This is often carried over from commands and client calls. Most events
     * won't have this information, and how this information is used is dependent upon the interface
     * that reads it.
     * Current well-known uses:
     *  * workflow_execution_started_event_attributes - summary and details from start workflow.
     *  * timer_started_event_attributes - summary represents an identifier for the timer for use by
     *    user interfaces.
     *
     * Generated from protobuf field <code>.temporal.api.sdk.v1.UserMetadata user_metadata = 301;</code>
     */
    protected $user_metadata = null;
    /**
     * Links associated with the event.
     *
     * Generated from protobuf field <code>repeated .temporal.api.common.v1.Link links = 302;</code>
     */
    private $links;
    protected $attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $event_id
     *           Monotonically increasing event number, starts at 1.
     *     @type \Google\Protobuf\Timestamp $event_time
     *     @type int $event_type
     *     @type int|string $version
     *           TODO: What is this? Appears unused by SDKs
     *     @type int|string $task_id
     *           TODO: What is this? Appears unused by SDKs
     *     @type bool $worker_may_ignore
     *           Set to true when the SDK may ignore the event as it does not impact workflow state or
     *           information in any way that the SDK need be concerned with. If an SDK encounters an event
     *           type which it does not understand, it must error unless this is true. If it is true, it's
     *           acceptable for the event type and/or attributes to be uninterpretable.
     *     @type \Temporal\Api\Sdk\V1\UserMetadata $user_metadata
     *           Metadata on the event. This is often carried over from commands and client calls. Most events
     *           won't have this information, and how this information is used is dependent upon the interface
     *           that reads it.
     *           Current well-known uses:
     *            * workflow_execution_started_event_attributes - summary and details from start workflow.
     *            * timer_started_event_attributes - summary represents an identifier for the timer for use by
     *              user interfaces.
     *     @type \Temporal\Api\Common\V1\Link[] $links
     *           Links associated with the event.
     *     @type \Temporal\Api\History\V1\WorkflowExecutionStartedEventAttributes $workflow_execution_started_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionCompletedEventAttributes $workflow_execution_completed_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionFailedEventAttributes $workflow_execution_failed_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionTimedOutEventAttributes $workflow_execution_timed_out_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowTaskScheduledEventAttributes $workflow_task_scheduled_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowTaskStartedEventAttributes $workflow_task_started_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowTaskCompletedEventAttributes $workflow_task_completed_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowTaskTimedOutEventAttributes $workflow_task_timed_out_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowTaskFailedEventAttributes $workflow_task_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskScheduledEventAttributes $activity_task_scheduled_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskStartedEventAttributes $activity_task_started_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskCompletedEventAttributes $activity_task_completed_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskFailedEventAttributes $activity_task_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskTimedOutEventAttributes $activity_task_timed_out_event_attributes
     *     @type \Temporal\Api\History\V1\TimerStartedEventAttributes $timer_started_event_attributes
     *     @type \Temporal\Api\History\V1\TimerFiredEventAttributes $timer_fired_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskCancelRequestedEventAttributes $activity_task_cancel_requested_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityTaskCanceledEventAttributes $activity_task_canceled_event_attributes
     *     @type \Temporal\Api\History\V1\TimerCanceledEventAttributes $timer_canceled_event_attributes
     *     @type \Temporal\Api\History\V1\MarkerRecordedEventAttributes $marker_recorded_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionSignaledEventAttributes $workflow_execution_signaled_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionTerminatedEventAttributes $workflow_execution_terminated_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionCancelRequestedEventAttributes $workflow_execution_cancel_requested_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionCanceledEventAttributes $workflow_execution_canceled_event_attributes
     *     @type \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionInitiatedEventAttributes $request_cancel_external_workflow_execution_initiated_event_attributes
     *     @type \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionFailedEventAttributes $request_cancel_external_workflow_execution_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ExternalWorkflowExecutionCancelRequestedEventAttributes $external_workflow_execution_cancel_requested_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionContinuedAsNewEventAttributes $workflow_execution_continued_as_new_event_attributes
     *     @type \Temporal\Api\History\V1\StartChildWorkflowExecutionInitiatedEventAttributes $start_child_workflow_execution_initiated_event_attributes
     *     @type \Temporal\Api\History\V1\StartChildWorkflowExecutionFailedEventAttributes $start_child_workflow_execution_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionStartedEventAttributes $child_workflow_execution_started_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionCompletedEventAttributes $child_workflow_execution_completed_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionFailedEventAttributes $child_workflow_execution_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionCanceledEventAttributes $child_workflow_execution_canceled_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionTimedOutEventAttributes $child_workflow_execution_timed_out_event_attributes
     *     @type \Temporal\Api\History\V1\ChildWorkflowExecutionTerminatedEventAttributes $child_workflow_execution_terminated_event_attributes
     *     @type \Temporal\Api\History\V1\SignalExternalWorkflowExecutionInitiatedEventAttributes $signal_external_workflow_execution_initiated_event_attributes
     *     @type \Temporal\Api\History\V1\SignalExternalWorkflowExecutionFailedEventAttributes $signal_external_workflow_execution_failed_event_attributes
     *     @type \Temporal\Api\History\V1\ExternalWorkflowExecutionSignaledEventAttributes $external_workflow_execution_signaled_event_attributes
     *     @type \Temporal\Api\History\V1\UpsertWorkflowSearchAttributesEventAttributes $upsert_workflow_search_attributes_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionUpdateAcceptedEventAttributes $workflow_execution_update_accepted_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionUpdateRejectedEventAttributes $workflow_execution_update_rejected_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionUpdateCompletedEventAttributes $workflow_execution_update_completed_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowPropertiesModifiedExternallyEventAttributes $workflow_properties_modified_externally_event_attributes
     *     @type \Temporal\Api\History\V1\ActivityPropertiesModifiedExternallyEventAttributes $activity_properties_modified_externally_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowPropertiesModifiedEventAttributes $workflow_properties_modified_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionUpdateAdmittedEventAttributes $workflow_execution_update_admitted_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationScheduledEventAttributes $nexus_operation_scheduled_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationStartedEventAttributes $nexus_operation_started_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationCompletedEventAttributes $nexus_operation_completed_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationFailedEventAttributes $nexus_operation_failed_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationCanceledEventAttributes $nexus_operation_canceled_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationTimedOutEventAttributes $nexus_operation_timed_out_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationCancelRequestedEventAttributes $nexus_operation_cancel_requested_event_attributes
     *     @type \Temporal\Api\History\V1\WorkflowExecutionOptionsUpdatedEventAttributes $workflow_execution_options_updated_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationCancelRequestCompletedEventAttributes $nexus_operation_cancel_request_completed_event_attributes
     *     @type \Temporal\Api\History\V1\NexusOperationCancelRequestFailedEventAttributes $nexus_operation_cancel_request_failed_event_attributes
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\History\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Monotonically increasing event number, starts at 1.
     *
     * Generated from protobuf field <code>int64 event_id = 1;</code>
     * @return int|string
     */
    public function getEventId()
    {
        return $this->event_id;
    }

    /**
     * Monotonically increasing event number, starts at 1.
     *
     * Generated from protobuf field <code>int64 event_id = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setEventId($var)
    {
        GPBUtil::checkInt64($var);
        $this->event_id = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return $this->event_time;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.enums.v1.EventType event_type = 3;</code>
     * @return int
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.enums.v1.EventType event_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkEnum($var, \Temporal\Api\Enums\V1\EventType::class);
        $this->event_type = $var;

        return $this;
    }

    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 version = 4;</code>
     * @return int|string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 version = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkInt64($var);
        $this->version = $var;

        return $this;
    }

    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 task_id = 5;</code>
     * @return int|string
     */
    public function getTaskId()
    {
        return $this->task_id;
    }

    /**
     * TODO: What is this? Appears unused by SDKs
     *
     * Generated from protobuf field <code>int64 task_id = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTaskId($var)
    {
        GPBUtil::checkInt64($var);
        $this->task_id = $var;

        return $this;
    }

    /**
     * Set to true when the SDK may ignore the event as it does not impact workflow state or
     * information in any way that the SDK need be concerned with. If an SDK encounters an event
     * type which it does not understand, it must error unless this is true. If it is true, it's
     * acceptable for the event type and/or attributes to be uninterpretable.
     *
     * Generated from protobuf field <code>bool worker_may_ignore = 300;</code>
     * @return bool
     */
    public function getWorkerMayIgnore()
    {
        return $this->worker_may_ignore;
    }

    /**
     * Set to true when the SDK may ignore the event as it does not impact workflow state or
     * information in any way that the SDK need be concerned with. If an SDK encounters an event
     * type which it does not understand, it must error unless this is true. If it is true, it's
     * acceptable for the event type and/or attributes to be uninterpretable.
     *
     * Generated from protobuf field <code>bool worker_may_ignore = 300;</code>
     * @param bool $var
     * @return $this
     */
    public function setWorkerMayIgnore($var)
    {
        GPBUtil::checkBool($var);
        $this->worker_may_ignore = $var;

        return $this;
    }

    /**
     * Metadata on the event. This is often carried over from commands and client calls. Most events
     * won't have this information, and how this information is used is dependent upon the interface
     * that reads it.
     * Current well-known uses:
     *  * workflow_execution_started_event_attributes - summary and details from start workflow.
     *  * timer_started_event_attributes - summary represents an identifier for the timer for use by
     *    user interfaces.
     *
     * Generated from protobuf field <code>.temporal.api.sdk.v1.UserMetadata user_metadata = 301;</code>
     * @return \Temporal\Api\Sdk\V1\UserMetadata|null
     */
    public function getUserMetadata()
    {
        return $this->user_metadata;
    }

    public function hasUserMetadata()
    {
        return isset($this->user_metadata);
    }

    public function clearUserMetadata()
    {
        unset($this->user_metadata);
    }

    /**
     * Metadata on the event. This is often carried over from commands and client calls. Most events
     * won't have this information, and how this information is used is dependent upon the interface
     * that reads it.
     * Current well-known uses:
     *  * workflow_execution_started_event_attributes - summary and details from start workflow.
     *  * timer_started_event_attributes - summary represents an identifier for the timer for use by
     *    user interfaces.
     *
     * Generated from protobuf field <code>.temporal.api.sdk.v1.UserMetadata user_metadata = 301;</code>
     * @param \Temporal\Api\Sdk\V1\UserMetadata $var
     * @return $this
     */
    public function setUserMetadata($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\Sdk\V1\UserMetadata::class);
        $this->user_metadata = $var;

        return $this;
    }

    /**
     * Links associated with the event.
     *
     * Generated from protobuf field <code>repeated .temporal.api.common.v1.Link links = 302;</code>
     * @return RepeatedField<\Temporal\Api\Common\V1\Link>
     */
    public function getLinks()
    {
        return $this->links;
    }

    /**
     * Links associated with the event.
     *
     * Generated from protobuf field <code>repeated .temporal.api.common.v1.Link links = 302;</code>
     * @param \Temporal\Api\Common\V1\Link[] $var
     * @return $this
     */
    public function setLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Temporal\Api\Common\V1\Link::class);
        $this->links = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes workflow_execution_started_event_attributes = 6;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionStartedEventAttributes|null
     */
    public function getWorkflowExecutionStartedEventAttributes()
    {
        return $this->readOneof(6);
    }

    public function hasWorkflowExecutionStartedEventAttributes()
    {
        return $this->hasOneof(6);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes workflow_execution_started_event_attributes = 6;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionStartedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionStartedEventAttributes::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCompletedEventAttributes workflow_execution_completed_event_attributes = 7;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionCompletedEventAttributes|null
     */
    public function getWorkflowExecutionCompletedEventAttributes()
    {
        return $this->readOneof(7);
    }

    public function hasWorkflowExecutionCompletedEventAttributes()
    {
        return $this->hasOneof(7);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCompletedEventAttributes workflow_execution_completed_event_attributes = 7;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionCompletedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionCompletedEventAttributes::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionFailedEventAttributes workflow_execution_failed_event_attributes = 8;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionFailedEventAttributes|null
     */
    public function getWorkflowExecutionFailedEventAttributes()
    {
        return $this->readOneof(8);
    }

    public function hasWorkflowExecutionFailedEventAttributes()
    {
        return $this->hasOneof(8);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionFailedEventAttributes workflow_execution_failed_event_attributes = 8;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionFailedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionFailedEventAttributes::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionTimedOutEventAttributes workflow_execution_timed_out_event_attributes = 9;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionTimedOutEventAttributes|null
     */
    public function getWorkflowExecutionTimedOutEventAttributes()
    {
        return $this->readOneof(9);
    }

    public function hasWorkflowExecutionTimedOutEventAttributes()
    {
        return $this->hasOneof(9);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionTimedOutEventAttributes workflow_execution_timed_out_event_attributes = 9;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionTimedOutEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionTimedOutEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionTimedOutEventAttributes::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskScheduledEventAttributes workflow_task_scheduled_event_attributes = 10;</code>
     * @return \Temporal\Api\History\V1\WorkflowTaskScheduledEventAttributes|null
     */
    public function getWorkflowTaskScheduledEventAttributes()
    {
        return $this->readOneof(10);
    }

    public function hasWorkflowTaskScheduledEventAttributes()
    {
        return $this->hasOneof(10);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskScheduledEventAttributes workflow_task_scheduled_event_attributes = 10;</code>
     * @param \Temporal\Api\History\V1\WorkflowTaskScheduledEventAttributes $var
     * @return $this
     */
    public function setWorkflowTaskScheduledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowTaskScheduledEventAttributes::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskStartedEventAttributes workflow_task_started_event_attributes = 11;</code>
     * @return \Temporal\Api\History\V1\WorkflowTaskStartedEventAttributes|null
     */
    public function getWorkflowTaskStartedEventAttributes()
    {
        return $this->readOneof(11);
    }

    public function hasWorkflowTaskStartedEventAttributes()
    {
        return $this->hasOneof(11);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskStartedEventAttributes workflow_task_started_event_attributes = 11;</code>
     * @param \Temporal\Api\History\V1\WorkflowTaskStartedEventAttributes $var
     * @return $this
     */
    public function setWorkflowTaskStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowTaskStartedEventAttributes::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskCompletedEventAttributes workflow_task_completed_event_attributes = 12;</code>
     * @return \Temporal\Api\History\V1\WorkflowTaskCompletedEventAttributes|null
     */
    public function getWorkflowTaskCompletedEventAttributes()
    {
        return $this->readOneof(12);
    }

    public function hasWorkflowTaskCompletedEventAttributes()
    {
        return $this->hasOneof(12);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskCompletedEventAttributes workflow_task_completed_event_attributes = 12;</code>
     * @param \Temporal\Api\History\V1\WorkflowTaskCompletedEventAttributes $var
     * @return $this
     */
    public function setWorkflowTaskCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowTaskCompletedEventAttributes::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskTimedOutEventAttributes workflow_task_timed_out_event_attributes = 13;</code>
     * @return \Temporal\Api\History\V1\WorkflowTaskTimedOutEventAttributes|null
     */
    public function getWorkflowTaskTimedOutEventAttributes()
    {
        return $this->readOneof(13);
    }

    public function hasWorkflowTaskTimedOutEventAttributes()
    {
        return $this->hasOneof(13);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskTimedOutEventAttributes workflow_task_timed_out_event_attributes = 13;</code>
     * @param \Temporal\Api\History\V1\WorkflowTaskTimedOutEventAttributes $var
     * @return $this
     */
    public function setWorkflowTaskTimedOutEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowTaskTimedOutEventAttributes::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskFailedEventAttributes workflow_task_failed_event_attributes = 14;</code>
     * @return \Temporal\Api\History\V1\WorkflowTaskFailedEventAttributes|null
     */
    public function getWorkflowTaskFailedEventAttributes()
    {
        return $this->readOneof(14);
    }

    public function hasWorkflowTaskFailedEventAttributes()
    {
        return $this->hasOneof(14);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowTaskFailedEventAttributes workflow_task_failed_event_attributes = 14;</code>
     * @param \Temporal\Api\History\V1\WorkflowTaskFailedEventAttributes $var
     * @return $this
     */
    public function setWorkflowTaskFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowTaskFailedEventAttributes::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskScheduledEventAttributes activity_task_scheduled_event_attributes = 15;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskScheduledEventAttributes|null
     */
    public function getActivityTaskScheduledEventAttributes()
    {
        return $this->readOneof(15);
    }

    public function hasActivityTaskScheduledEventAttributes()
    {
        return $this->hasOneof(15);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskScheduledEventAttributes activity_task_scheduled_event_attributes = 15;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskScheduledEventAttributes $var
     * @return $this
     */
    public function setActivityTaskScheduledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskScheduledEventAttributes::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskStartedEventAttributes activity_task_started_event_attributes = 16;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskStartedEventAttributes|null
     */
    public function getActivityTaskStartedEventAttributes()
    {
        return $this->readOneof(16);
    }

    public function hasActivityTaskStartedEventAttributes()
    {
        return $this->hasOneof(16);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskStartedEventAttributes activity_task_started_event_attributes = 16;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskStartedEventAttributes $var
     * @return $this
     */
    public function setActivityTaskStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskStartedEventAttributes::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCompletedEventAttributes activity_task_completed_event_attributes = 17;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskCompletedEventAttributes|null
     */
    public function getActivityTaskCompletedEventAttributes()
    {
        return $this->readOneof(17);
    }

    public function hasActivityTaskCompletedEventAttributes()
    {
        return $this->hasOneof(17);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCompletedEventAttributes activity_task_completed_event_attributes = 17;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskCompletedEventAttributes $var
     * @return $this
     */
    public function setActivityTaskCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskCompletedEventAttributes::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskFailedEventAttributes activity_task_failed_event_attributes = 18;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskFailedEventAttributes|null
     */
    public function getActivityTaskFailedEventAttributes()
    {
        return $this->readOneof(18);
    }

    public function hasActivityTaskFailedEventAttributes()
    {
        return $this->hasOneof(18);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskFailedEventAttributes activity_task_failed_event_attributes = 18;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskFailedEventAttributes $var
     * @return $this
     */
    public function setActivityTaskFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskFailedEventAttributes::class);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskTimedOutEventAttributes activity_task_timed_out_event_attributes = 19;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskTimedOutEventAttributes|null
     */
    public function getActivityTaskTimedOutEventAttributes()
    {
        return $this->readOneof(19);
    }

    public function hasActivityTaskTimedOutEventAttributes()
    {
        return $this->hasOneof(19);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskTimedOutEventAttributes activity_task_timed_out_event_attributes = 19;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskTimedOutEventAttributes $var
     * @return $this
     */
    public function setActivityTaskTimedOutEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskTimedOutEventAttributes::class);
        $this->writeOneof(19, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerStartedEventAttributes timer_started_event_attributes = 20;</code>
     * @return \Temporal\Api\History\V1\TimerStartedEventAttributes|null
     */
    public function getTimerStartedEventAttributes()
    {
        return $this->readOneof(20);
    }

    public function hasTimerStartedEventAttributes()
    {
        return $this->hasOneof(20);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerStartedEventAttributes timer_started_event_attributes = 20;</code>
     * @param \Temporal\Api\History\V1\TimerStartedEventAttributes $var
     * @return $this
     */
    public function setTimerStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\TimerStartedEventAttributes::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerFiredEventAttributes timer_fired_event_attributes = 21;</code>
     * @return \Temporal\Api\History\V1\TimerFiredEventAttributes|null
     */
    public function getTimerFiredEventAttributes()
    {
        return $this->readOneof(21);
    }

    public function hasTimerFiredEventAttributes()
    {
        return $this->hasOneof(21);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerFiredEventAttributes timer_fired_event_attributes = 21;</code>
     * @param \Temporal\Api\History\V1\TimerFiredEventAttributes $var
     * @return $this
     */
    public function setTimerFiredEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\TimerFiredEventAttributes::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCancelRequestedEventAttributes activity_task_cancel_requested_event_attributes = 22;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskCancelRequestedEventAttributes|null
     */
    public function getActivityTaskCancelRequestedEventAttributes()
    {
        return $this->readOneof(22);
    }

    public function hasActivityTaskCancelRequestedEventAttributes()
    {
        return $this->hasOneof(22);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCancelRequestedEventAttributes activity_task_cancel_requested_event_attributes = 22;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskCancelRequestedEventAttributes $var
     * @return $this
     */
    public function setActivityTaskCancelRequestedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskCancelRequestedEventAttributes::class);
        $this->writeOneof(22, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCanceledEventAttributes activity_task_canceled_event_attributes = 23;</code>
     * @return \Temporal\Api\History\V1\ActivityTaskCanceledEventAttributes|null
     */
    public function getActivityTaskCanceledEventAttributes()
    {
        return $this->readOneof(23);
    }

    public function hasActivityTaskCanceledEventAttributes()
    {
        return $this->hasOneof(23);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityTaskCanceledEventAttributes activity_task_canceled_event_attributes = 23;</code>
     * @param \Temporal\Api\History\V1\ActivityTaskCanceledEventAttributes $var
     * @return $this
     */
    public function setActivityTaskCanceledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityTaskCanceledEventAttributes::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerCanceledEventAttributes timer_canceled_event_attributes = 24;</code>
     * @return \Temporal\Api\History\V1\TimerCanceledEventAttributes|null
     */
    public function getTimerCanceledEventAttributes()
    {
        return $this->readOneof(24);
    }

    public function hasTimerCanceledEventAttributes()
    {
        return $this->hasOneof(24);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.TimerCanceledEventAttributes timer_canceled_event_attributes = 24;</code>
     * @param \Temporal\Api\History\V1\TimerCanceledEventAttributes $var
     * @return $this
     */
    public function setTimerCanceledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\TimerCanceledEventAttributes::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.MarkerRecordedEventAttributes marker_recorded_event_attributes = 25;</code>
     * @return \Temporal\Api\History\V1\MarkerRecordedEventAttributes|null
     */
    public function getMarkerRecordedEventAttributes()
    {
        return $this->readOneof(25);
    }

    public function hasMarkerRecordedEventAttributes()
    {
        return $this->hasOneof(25);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.MarkerRecordedEventAttributes marker_recorded_event_attributes = 25;</code>
     * @param \Temporal\Api\History\V1\MarkerRecordedEventAttributes $var
     * @return $this
     */
    public function setMarkerRecordedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\MarkerRecordedEventAttributes::class);
        $this->writeOneof(25, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes workflow_execution_signaled_event_attributes = 26;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionSignaledEventAttributes|null
     */
    public function getWorkflowExecutionSignaledEventAttributes()
    {
        return $this->readOneof(26);
    }

    public function hasWorkflowExecutionSignaledEventAttributes()
    {
        return $this->hasOneof(26);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionSignaledEventAttributes workflow_execution_signaled_event_attributes = 26;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionSignaledEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionSignaledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionSignaledEventAttributes::class);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionTerminatedEventAttributes workflow_execution_terminated_event_attributes = 27;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionTerminatedEventAttributes|null
     */
    public function getWorkflowExecutionTerminatedEventAttributes()
    {
        return $this->readOneof(27);
    }

    public function hasWorkflowExecutionTerminatedEventAttributes()
    {
        return $this->hasOneof(27);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionTerminatedEventAttributes workflow_execution_terminated_event_attributes = 27;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionTerminatedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionTerminatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionTerminatedEventAttributes::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCancelRequestedEventAttributes workflow_execution_cancel_requested_event_attributes = 28;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionCancelRequestedEventAttributes|null
     */
    public function getWorkflowExecutionCancelRequestedEventAttributes()
    {
        return $this->readOneof(28);
    }

    public function hasWorkflowExecutionCancelRequestedEventAttributes()
    {
        return $this->hasOneof(28);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCancelRequestedEventAttributes workflow_execution_cancel_requested_event_attributes = 28;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionCancelRequestedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionCancelRequestedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionCancelRequestedEventAttributes::class);
        $this->writeOneof(28, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCanceledEventAttributes workflow_execution_canceled_event_attributes = 29;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionCanceledEventAttributes|null
     */
    public function getWorkflowExecutionCanceledEventAttributes()
    {
        return $this->readOneof(29);
    }

    public function hasWorkflowExecutionCanceledEventAttributes()
    {
        return $this->hasOneof(29);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionCanceledEventAttributes workflow_execution_canceled_event_attributes = 29;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionCanceledEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionCanceledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionCanceledEventAttributes::class);
        $this->writeOneof(29, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes request_cancel_external_workflow_execution_initiated_event_attributes = 30;</code>
     * @return \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionInitiatedEventAttributes|null
     */
    public function getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->readOneof(30);
    }

    public function hasRequestCancelExternalWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->hasOneof(30);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes request_cancel_external_workflow_execution_initiated_event_attributes = 30;</code>
     * @param \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionInitiatedEventAttributes $var
     * @return $this
     */
    public function setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionInitiatedEventAttributes::class);
        $this->writeOneof(30, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes request_cancel_external_workflow_execution_failed_event_attributes = 31;</code>
     * @return \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionFailedEventAttributes|null
     */
    public function getRequestCancelExternalWorkflowExecutionFailedEventAttributes()
    {
        return $this->readOneof(31);
    }

    public function hasRequestCancelExternalWorkflowExecutionFailedEventAttributes()
    {
        return $this->hasOneof(31);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.RequestCancelExternalWorkflowExecutionFailedEventAttributes request_cancel_external_workflow_execution_failed_event_attributes = 31;</code>
     * @param \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionFailedEventAttributes $var
     * @return $this
     */
    public function setRequestCancelExternalWorkflowExecutionFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\RequestCancelExternalWorkflowExecutionFailedEventAttributes::class);
        $this->writeOneof(31, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes external_workflow_execution_cancel_requested_event_attributes = 32;</code>
     * @return \Temporal\Api\History\V1\ExternalWorkflowExecutionCancelRequestedEventAttributes|null
     */
    public function getExternalWorkflowExecutionCancelRequestedEventAttributes()
    {
        return $this->readOneof(32);
    }

    public function hasExternalWorkflowExecutionCancelRequestedEventAttributes()
    {
        return $this->hasOneof(32);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ExternalWorkflowExecutionCancelRequestedEventAttributes external_workflow_execution_cancel_requested_event_attributes = 32;</code>
     * @param \Temporal\Api\History\V1\ExternalWorkflowExecutionCancelRequestedEventAttributes $var
     * @return $this
     */
    public function setExternalWorkflowExecutionCancelRequestedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ExternalWorkflowExecutionCancelRequestedEventAttributes::class);
        $this->writeOneof(32, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes workflow_execution_continued_as_new_event_attributes = 33;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionContinuedAsNewEventAttributes|null
     */
    public function getWorkflowExecutionContinuedAsNewEventAttributes()
    {
        return $this->readOneof(33);
    }

    public function hasWorkflowExecutionContinuedAsNewEventAttributes()
    {
        return $this->hasOneof(33);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes workflow_execution_continued_as_new_event_attributes = 33;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionContinuedAsNewEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionContinuedAsNewEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionContinuedAsNewEventAttributes::class);
        $this->writeOneof(33, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.StartChildWorkflowExecutionInitiatedEventAttributes start_child_workflow_execution_initiated_event_attributes = 34;</code>
     * @return \Temporal\Api\History\V1\StartChildWorkflowExecutionInitiatedEventAttributes|null
     */
    public function getStartChildWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->readOneof(34);
    }

    public function hasStartChildWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->hasOneof(34);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.StartChildWorkflowExecutionInitiatedEventAttributes start_child_workflow_execution_initiated_event_attributes = 34;</code>
     * @param \Temporal\Api\History\V1\StartChildWorkflowExecutionInitiatedEventAttributes $var
     * @return $this
     */
    public function setStartChildWorkflowExecutionInitiatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\StartChildWorkflowExecutionInitiatedEventAttributes::class);
        $this->writeOneof(34, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes start_child_workflow_execution_failed_event_attributes = 35;</code>
     * @return \Temporal\Api\History\V1\StartChildWorkflowExecutionFailedEventAttributes|null
     */
    public function getStartChildWorkflowExecutionFailedEventAttributes()
    {
        return $this->readOneof(35);
    }

    public function hasStartChildWorkflowExecutionFailedEventAttributes()
    {
        return $this->hasOneof(35);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes start_child_workflow_execution_failed_event_attributes = 35;</code>
     * @param \Temporal\Api\History\V1\StartChildWorkflowExecutionFailedEventAttributes $var
     * @return $this
     */
    public function setStartChildWorkflowExecutionFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\StartChildWorkflowExecutionFailedEventAttributes::class);
        $this->writeOneof(35, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionStartedEventAttributes child_workflow_execution_started_event_attributes = 36;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionStartedEventAttributes|null
     */
    public function getChildWorkflowExecutionStartedEventAttributes()
    {
        return $this->readOneof(36);
    }

    public function hasChildWorkflowExecutionStartedEventAttributes()
    {
        return $this->hasOneof(36);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionStartedEventAttributes child_workflow_execution_started_event_attributes = 36;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionStartedEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionStartedEventAttributes::class);
        $this->writeOneof(36, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes child_workflow_execution_completed_event_attributes = 37;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionCompletedEventAttributes|null
     */
    public function getChildWorkflowExecutionCompletedEventAttributes()
    {
        return $this->readOneof(37);
    }

    public function hasChildWorkflowExecutionCompletedEventAttributes()
    {
        return $this->hasOneof(37);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes child_workflow_execution_completed_event_attributes = 37;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionCompletedEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionCompletedEventAttributes::class);
        $this->writeOneof(37, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes child_workflow_execution_failed_event_attributes = 38;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionFailedEventAttributes|null
     */
    public function getChildWorkflowExecutionFailedEventAttributes()
    {
        return $this->readOneof(38);
    }

    public function hasChildWorkflowExecutionFailedEventAttributes()
    {
        return $this->hasOneof(38);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes child_workflow_execution_failed_event_attributes = 38;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionFailedEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionFailedEventAttributes::class);
        $this->writeOneof(38, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes child_workflow_execution_canceled_event_attributes = 39;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionCanceledEventAttributes|null
     */
    public function getChildWorkflowExecutionCanceledEventAttributes()
    {
        return $this->readOneof(39);
    }

    public function hasChildWorkflowExecutionCanceledEventAttributes()
    {
        return $this->hasOneof(39);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes child_workflow_execution_canceled_event_attributes = 39;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionCanceledEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionCanceledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionCanceledEventAttributes::class);
        $this->writeOneof(39, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes child_workflow_execution_timed_out_event_attributes = 40;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionTimedOutEventAttributes|null
     */
    public function getChildWorkflowExecutionTimedOutEventAttributes()
    {
        return $this->readOneof(40);
    }

    public function hasChildWorkflowExecutionTimedOutEventAttributes()
    {
        return $this->hasOneof(40);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes child_workflow_execution_timed_out_event_attributes = 40;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionTimedOutEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionTimedOutEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionTimedOutEventAttributes::class);
        $this->writeOneof(40, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionTerminatedEventAttributes child_workflow_execution_terminated_event_attributes = 41;</code>
     * @return \Temporal\Api\History\V1\ChildWorkflowExecutionTerminatedEventAttributes|null
     */
    public function getChildWorkflowExecutionTerminatedEventAttributes()
    {
        return $this->readOneof(41);
    }

    public function hasChildWorkflowExecutionTerminatedEventAttributes()
    {
        return $this->hasOneof(41);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ChildWorkflowExecutionTerminatedEventAttributes child_workflow_execution_terminated_event_attributes = 41;</code>
     * @param \Temporal\Api\History\V1\ChildWorkflowExecutionTerminatedEventAttributes $var
     * @return $this
     */
    public function setChildWorkflowExecutionTerminatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ChildWorkflowExecutionTerminatedEventAttributes::class);
        $this->writeOneof(41, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes signal_external_workflow_execution_initiated_event_attributes = 42;</code>
     * @return \Temporal\Api\History\V1\SignalExternalWorkflowExecutionInitiatedEventAttributes|null
     */
    public function getSignalExternalWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->readOneof(42);
    }

    public function hasSignalExternalWorkflowExecutionInitiatedEventAttributes()
    {
        return $this->hasOneof(42);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.SignalExternalWorkflowExecutionInitiatedEventAttributes signal_external_workflow_execution_initiated_event_attributes = 42;</code>
     * @param \Temporal\Api\History\V1\SignalExternalWorkflowExecutionInitiatedEventAttributes $var
     * @return $this
     */
    public function setSignalExternalWorkflowExecutionInitiatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\SignalExternalWorkflowExecutionInitiatedEventAttributes::class);
        $this->writeOneof(42, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.SignalExternalWorkflowExecutionFailedEventAttributes signal_external_workflow_execution_failed_event_attributes = 43;</code>
     * @return \Temporal\Api\History\V1\SignalExternalWorkflowExecutionFailedEventAttributes|null
     */
    public function getSignalExternalWorkflowExecutionFailedEventAttributes()
    {
        return $this->readOneof(43);
    }

    public function hasSignalExternalWorkflowExecutionFailedEventAttributes()
    {
        return $this->hasOneof(43);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.SignalExternalWorkflowExecutionFailedEventAttributes signal_external_workflow_execution_failed_event_attributes = 43;</code>
     * @param \Temporal\Api\History\V1\SignalExternalWorkflowExecutionFailedEventAttributes $var
     * @return $this
     */
    public function setSignalExternalWorkflowExecutionFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\SignalExternalWorkflowExecutionFailedEventAttributes::class);
        $this->writeOneof(43, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ExternalWorkflowExecutionSignaledEventAttributes external_workflow_execution_signaled_event_attributes = 44;</code>
     * @return \Temporal\Api\History\V1\ExternalWorkflowExecutionSignaledEventAttributes|null
     */
    public function getExternalWorkflowExecutionSignaledEventAttributes()
    {
        return $this->readOneof(44);
    }

    public function hasExternalWorkflowExecutionSignaledEventAttributes()
    {
        return $this->hasOneof(44);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ExternalWorkflowExecutionSignaledEventAttributes external_workflow_execution_signaled_event_attributes = 44;</code>
     * @param \Temporal\Api\History\V1\ExternalWorkflowExecutionSignaledEventAttributes $var
     * @return $this
     */
    public function setExternalWorkflowExecutionSignaledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ExternalWorkflowExecutionSignaledEventAttributes::class);
        $this->writeOneof(44, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.UpsertWorkflowSearchAttributesEventAttributes upsert_workflow_search_attributes_event_attributes = 45;</code>
     * @return \Temporal\Api\History\V1\UpsertWorkflowSearchAttributesEventAttributes|null
     */
    public function getUpsertWorkflowSearchAttributesEventAttributes()
    {
        return $this->readOneof(45);
    }

    public function hasUpsertWorkflowSearchAttributesEventAttributes()
    {
        return $this->hasOneof(45);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.UpsertWorkflowSearchAttributesEventAttributes upsert_workflow_search_attributes_event_attributes = 45;</code>
     * @param \Temporal\Api\History\V1\UpsertWorkflowSearchAttributesEventAttributes $var
     * @return $this
     */
    public function setUpsertWorkflowSearchAttributesEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\UpsertWorkflowSearchAttributesEventAttributes::class);
        $this->writeOneof(45, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateAcceptedEventAttributes workflow_execution_update_accepted_event_attributes = 46;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionUpdateAcceptedEventAttributes|null
     */
    public function getWorkflowExecutionUpdateAcceptedEventAttributes()
    {
        return $this->readOneof(46);
    }

    public function hasWorkflowExecutionUpdateAcceptedEventAttributes()
    {
        return $this->hasOneof(46);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateAcceptedEventAttributes workflow_execution_update_accepted_event_attributes = 46;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionUpdateAcceptedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionUpdateAcceptedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionUpdateAcceptedEventAttributes::class);
        $this->writeOneof(46, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateRejectedEventAttributes workflow_execution_update_rejected_event_attributes = 47;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionUpdateRejectedEventAttributes|null
     */
    public function getWorkflowExecutionUpdateRejectedEventAttributes()
    {
        return $this->readOneof(47);
    }

    public function hasWorkflowExecutionUpdateRejectedEventAttributes()
    {
        return $this->hasOneof(47);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateRejectedEventAttributes workflow_execution_update_rejected_event_attributes = 47;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionUpdateRejectedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionUpdateRejectedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionUpdateRejectedEventAttributes::class);
        $this->writeOneof(47, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateCompletedEventAttributes workflow_execution_update_completed_event_attributes = 48;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionUpdateCompletedEventAttributes|null
     */
    public function getWorkflowExecutionUpdateCompletedEventAttributes()
    {
        return $this->readOneof(48);
    }

    public function hasWorkflowExecutionUpdateCompletedEventAttributes()
    {
        return $this->hasOneof(48);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateCompletedEventAttributes workflow_execution_update_completed_event_attributes = 48;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionUpdateCompletedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionUpdateCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionUpdateCompletedEventAttributes::class);
        $this->writeOneof(48, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowPropertiesModifiedExternallyEventAttributes workflow_properties_modified_externally_event_attributes = 49;</code>
     * @return \Temporal\Api\History\V1\WorkflowPropertiesModifiedExternallyEventAttributes|null
     */
    public function getWorkflowPropertiesModifiedExternallyEventAttributes()
    {
        return $this->readOneof(49);
    }

    public function hasWorkflowPropertiesModifiedExternallyEventAttributes()
    {
        return $this->hasOneof(49);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowPropertiesModifiedExternallyEventAttributes workflow_properties_modified_externally_event_attributes = 49;</code>
     * @param \Temporal\Api\History\V1\WorkflowPropertiesModifiedExternallyEventAttributes $var
     * @return $this
     */
    public function setWorkflowPropertiesModifiedExternallyEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowPropertiesModifiedExternallyEventAttributes::class);
        $this->writeOneof(49, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityPropertiesModifiedExternallyEventAttributes activity_properties_modified_externally_event_attributes = 50;</code>
     * @return \Temporal\Api\History\V1\ActivityPropertiesModifiedExternallyEventAttributes|null
     */
    public function getActivityPropertiesModifiedExternallyEventAttributes()
    {
        return $this->readOneof(50);
    }

    public function hasActivityPropertiesModifiedExternallyEventAttributes()
    {
        return $this->hasOneof(50);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.ActivityPropertiesModifiedExternallyEventAttributes activity_properties_modified_externally_event_attributes = 50;</code>
     * @param \Temporal\Api\History\V1\ActivityPropertiesModifiedExternallyEventAttributes $var
     * @return $this
     */
    public function setActivityPropertiesModifiedExternallyEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\ActivityPropertiesModifiedExternallyEventAttributes::class);
        $this->writeOneof(50, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowPropertiesModifiedEventAttributes workflow_properties_modified_event_attributes = 51;</code>
     * @return \Temporal\Api\History\V1\WorkflowPropertiesModifiedEventAttributes|null
     */
    public function getWorkflowPropertiesModifiedEventAttributes()
    {
        return $this->readOneof(51);
    }

    public function hasWorkflowPropertiesModifiedEventAttributes()
    {
        return $this->hasOneof(51);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowPropertiesModifiedEventAttributes workflow_properties_modified_event_attributes = 51;</code>
     * @param \Temporal\Api\History\V1\WorkflowPropertiesModifiedEventAttributes $var
     * @return $this
     */
    public function setWorkflowPropertiesModifiedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowPropertiesModifiedEventAttributes::class);
        $this->writeOneof(51, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateAdmittedEventAttributes workflow_execution_update_admitted_event_attributes = 52;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionUpdateAdmittedEventAttributes|null
     */
    public function getWorkflowExecutionUpdateAdmittedEventAttributes()
    {
        return $this->readOneof(52);
    }

    public function hasWorkflowExecutionUpdateAdmittedEventAttributes()
    {
        return $this->hasOneof(52);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionUpdateAdmittedEventAttributes workflow_execution_update_admitted_event_attributes = 52;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionUpdateAdmittedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionUpdateAdmittedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionUpdateAdmittedEventAttributes::class);
        $this->writeOneof(52, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationScheduledEventAttributes nexus_operation_scheduled_event_attributes = 53;</code>
     * @return \Temporal\Api\History\V1\NexusOperationScheduledEventAttributes|null
     */
    public function getNexusOperationScheduledEventAttributes()
    {
        return $this->readOneof(53);
    }

    public function hasNexusOperationScheduledEventAttributes()
    {
        return $this->hasOneof(53);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationScheduledEventAttributes nexus_operation_scheduled_event_attributes = 53;</code>
     * @param \Temporal\Api\History\V1\NexusOperationScheduledEventAttributes $var
     * @return $this
     */
    public function setNexusOperationScheduledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationScheduledEventAttributes::class);
        $this->writeOneof(53, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationStartedEventAttributes nexus_operation_started_event_attributes = 54;</code>
     * @return \Temporal\Api\History\V1\NexusOperationStartedEventAttributes|null
     */
    public function getNexusOperationStartedEventAttributes()
    {
        return $this->readOneof(54);
    }

    public function hasNexusOperationStartedEventAttributes()
    {
        return $this->hasOneof(54);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationStartedEventAttributes nexus_operation_started_event_attributes = 54;</code>
     * @param \Temporal\Api\History\V1\NexusOperationStartedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationStartedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationStartedEventAttributes::class);
        $this->writeOneof(54, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCompletedEventAttributes nexus_operation_completed_event_attributes = 55;</code>
     * @return \Temporal\Api\History\V1\NexusOperationCompletedEventAttributes|null
     */
    public function getNexusOperationCompletedEventAttributes()
    {
        return $this->readOneof(55);
    }

    public function hasNexusOperationCompletedEventAttributes()
    {
        return $this->hasOneof(55);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCompletedEventAttributes nexus_operation_completed_event_attributes = 55;</code>
     * @param \Temporal\Api\History\V1\NexusOperationCompletedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationCompletedEventAttributes::class);
        $this->writeOneof(55, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationFailedEventAttributes nexus_operation_failed_event_attributes = 56;</code>
     * @return \Temporal\Api\History\V1\NexusOperationFailedEventAttributes|null
     */
    public function getNexusOperationFailedEventAttributes()
    {
        return $this->readOneof(56);
    }

    public function hasNexusOperationFailedEventAttributes()
    {
        return $this->hasOneof(56);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationFailedEventAttributes nexus_operation_failed_event_attributes = 56;</code>
     * @param \Temporal\Api\History\V1\NexusOperationFailedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationFailedEventAttributes::class);
        $this->writeOneof(56, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCanceledEventAttributes nexus_operation_canceled_event_attributes = 57;</code>
     * @return \Temporal\Api\History\V1\NexusOperationCanceledEventAttributes|null
     */
    public function getNexusOperationCanceledEventAttributes()
    {
        return $this->readOneof(57);
    }

    public function hasNexusOperationCanceledEventAttributes()
    {
        return $this->hasOneof(57);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCanceledEventAttributes nexus_operation_canceled_event_attributes = 57;</code>
     * @param \Temporal\Api\History\V1\NexusOperationCanceledEventAttributes $var
     * @return $this
     */
    public function setNexusOperationCanceledEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationCanceledEventAttributes::class);
        $this->writeOneof(57, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationTimedOutEventAttributes nexus_operation_timed_out_event_attributes = 58;</code>
     * @return \Temporal\Api\History\V1\NexusOperationTimedOutEventAttributes|null
     */
    public function getNexusOperationTimedOutEventAttributes()
    {
        return $this->readOneof(58);
    }

    public function hasNexusOperationTimedOutEventAttributes()
    {
        return $this->hasOneof(58);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationTimedOutEventAttributes nexus_operation_timed_out_event_attributes = 58;</code>
     * @param \Temporal\Api\History\V1\NexusOperationTimedOutEventAttributes $var
     * @return $this
     */
    public function setNexusOperationTimedOutEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationTimedOutEventAttributes::class);
        $this->writeOneof(58, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestedEventAttributes nexus_operation_cancel_requested_event_attributes = 59;</code>
     * @return \Temporal\Api\History\V1\NexusOperationCancelRequestedEventAttributes|null
     */
    public function getNexusOperationCancelRequestedEventAttributes()
    {
        return $this->readOneof(59);
    }

    public function hasNexusOperationCancelRequestedEventAttributes()
    {
        return $this->hasOneof(59);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestedEventAttributes nexus_operation_cancel_requested_event_attributes = 59;</code>
     * @param \Temporal\Api\History\V1\NexusOperationCancelRequestedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationCancelRequestedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationCancelRequestedEventAttributes::class);
        $this->writeOneof(59, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionOptionsUpdatedEventAttributes workflow_execution_options_updated_event_attributes = 60;</code>
     * @return \Temporal\Api\History\V1\WorkflowExecutionOptionsUpdatedEventAttributes|null
     */
    public function getWorkflowExecutionOptionsUpdatedEventAttributes()
    {
        return $this->readOneof(60);
    }

    public function hasWorkflowExecutionOptionsUpdatedEventAttributes()
    {
        return $this->hasOneof(60);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.WorkflowExecutionOptionsUpdatedEventAttributes workflow_execution_options_updated_event_attributes = 60;</code>
     * @param \Temporal\Api\History\V1\WorkflowExecutionOptionsUpdatedEventAttributes $var
     * @return $this
     */
    public function setWorkflowExecutionOptionsUpdatedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\WorkflowExecutionOptionsUpdatedEventAttributes::class);
        $this->writeOneof(60, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestCompletedEventAttributes nexus_operation_cancel_request_completed_event_attributes = 61;</code>
     * @return \Temporal\Api\History\V1\NexusOperationCancelRequestCompletedEventAttributes|null
     */
    public function getNexusOperationCancelRequestCompletedEventAttributes()
    {
        return $this->readOneof(61);
    }

    public function hasNexusOperationCancelRequestCompletedEventAttributes()
    {
        return $this->hasOneof(61);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestCompletedEventAttributes nexus_operation_cancel_request_completed_event_attributes = 61;</code>
     * @param \Temporal\Api\History\V1\NexusOperationCancelRequestCompletedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationCancelRequestCompletedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationCancelRequestCompletedEventAttributes::class);
        $this->writeOneof(61, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestFailedEventAttributes nexus_operation_cancel_request_failed_event_attributes = 62;</code>
     * @return \Temporal\Api\History\V1\NexusOperationCancelRequestFailedEventAttributes|null
     */
    public function getNexusOperationCancelRequestFailedEventAttributes()
    {
        return $this->readOneof(62);
    }

    public function hasNexusOperationCancelRequestFailedEventAttributes()
    {
        return $this->hasOneof(62);
    }

    /**
     * Generated from protobuf field <code>.temporal.api.history.v1.NexusOperationCancelRequestFailedEventAttributes nexus_operation_cancel_request_failed_event_attributes = 62;</code>
     * @param \Temporal\Api\History\V1\NexusOperationCancelRequestFailedEventAttributes $var
     * @return $this
     */
    public function setNexusOperationCancelRequestFailedEventAttributes($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\History\V1\NexusOperationCancelRequestFailedEventAttributes::class);
        $this->writeOneof(62, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAttributes()
    {
        return $this->whichOneof("attributes");
    }

}

