<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/taskqueue/v1/message.proto

namespace Temporal\Api\Taskqueue\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * Assignment rules are applied to *new* Workflow and Activity executions at
 * schedule time to assign them to a Build ID.
 * Assignment rules will not be used in the following cases:
 *    - Child Workflows or Continue-As-New Executions who inherit their
 *      parent/previous Workflow's assigned Build ID (by setting the
 *      `inherit_build_id` flag - default behavior in SDKs when the same Task Queue
 *      is used.)
 *    - An Activity that inherits the assigned Build ID of its Workflow (by
 *      setting the `use_workflow_build_id` flag - default behavior in SDKs
 *      when the same Task Queue is used.)
 * In absence of (applicable) redirect rules (`CompatibleBuildIdRedirectRule`s)
 * the task will be dispatched to Workers of the Build ID determined by the
 * assignment rules (or inherited). Otherwise, the final Build ID will be
 * determined by the redirect rules.
 * Once a Workflow completes its first Workflow Task in a particular Build ID it
 * stays in that Build ID regardless of changes to assignment rules. Redirect
 * rules can be used to move the workflow to another compatible Build ID.
 * When using Worker Versioning on a Task Queue, in the steady state,
 * there should typically be a single assignment rule to send all new executions
 * to the latest Build ID. Existence of at least one such "unconditional"
 * rule at all times is enforces by the system, unless the `force` flag is used
 * by the user when replacing/deleting these rules (for exceptional cases).
 * During a deployment, one or more additional rules can be added to assign a
 * subset of the tasks to a new Build ID based on a "ramp percentage".
 * When there are multiple assignment rules for a Task Queue, the rules are
 * evaluated in order, starting from index 0. The first applicable rule will be
 * applied and the rest will be ignored.
 * In the event that no assignment rule is applicable on a task (or the Task
 * Queue is simply not versioned), the tasks will be dispatched to an
 * unversioned Worker.
 *
 * Generated from protobuf message <code>temporal.api.taskqueue.v1.BuildIdAssignmentRule</code>
 */
class BuildIdAssignmentRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Generated from protobuf field <code>string target_build_id = 1;</code>
     */
    protected $target_build_id = '';
    protected $ramp;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $target_build_id
     *     @type \Temporal\Api\Taskqueue\V1\RampByPercentage $percentage_ramp
     *           This ramp is useful for gradual Blue/Green deployments (and similar)
     *           where you want to send a certain portion of the traffic to the target
     *           Build ID.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\Taskqueue\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Generated from protobuf field <code>string target_build_id = 1;</code>
     * @return string
     */
    public function getTargetBuildId()
    {
        return $this->target_build_id;
    }

    /**
     * Generated from protobuf field <code>string target_build_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetBuildId($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_build_id = $var;

        return $this;
    }

    /**
     * This ramp is useful for gradual Blue/Green deployments (and similar)
     * where you want to send a certain portion of the traffic to the target
     * Build ID.
     *
     * Generated from protobuf field <code>.temporal.api.taskqueue.v1.RampByPercentage percentage_ramp = 3;</code>
     * @return \Temporal\Api\Taskqueue\V1\RampByPercentage|null
     */
    public function getPercentageRamp()
    {
        return $this->readOneof(3);
    }

    public function hasPercentageRamp()
    {
        return $this->hasOneof(3);
    }

    /**
     * This ramp is useful for gradual Blue/Green deployments (and similar)
     * where you want to send a certain portion of the traffic to the target
     * Build ID.
     *
     * Generated from protobuf field <code>.temporal.api.taskqueue.v1.RampByPercentage percentage_ramp = 3;</code>
     * @param \Temporal\Api\Taskqueue\V1\RampByPercentage $var
     * @return $this
     */
    public function setPercentageRamp($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\Taskqueue\V1\RampByPercentage::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRamp()
    {
        return $this->whichOneof("ramp");
    }

}

